<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Serverless\V1\Service\TwilioFunction\FunctionVersion;

use Twilio\ListResource;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
class FunctionVersionContentList extends ListResource {
    /**
     * Construct the FunctionVersionContentList
     *
     * @param Version $version Version that contains the resource
     * @param string $serviceSid The SID of the Service that the Function Version
     *                           resource is associated with
     * @param string $functionSid The SID of the Function that is the parent of the
     *                            Function Version
     * @param string $sid The unique string that identifies the Function Version
     *                    resource
     */
    public function __construct(Version $version, string $serviceSid, string $functionSid, string $sid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['serviceSid' => $serviceSid, 'functionSid' => $functionSid, 'sid' => $sid, ];
    }

    /**
     * Constructs a FunctionVersionContentContext
     */
    public function getContext(): FunctionVersionContentContext {
        return new FunctionVersionContentContext(
            $this->version,
            $this->solution['serviceSid'],
            $this->solution['functionSid'],
            $this->solution['sid']
        );
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Serverless.V1.FunctionVersionContentList]';
    }
}